// données
const symboles = [
  '💀', '💀', '⚰️', '⚰️', '🧟', '🧟', '🤡', '🤡',
  '🧛‍♂️', '🧛‍♂️', '🕷️', '🕷️', '👻', '👻', '🍬', '🍬'
];

// variables 
let premiereCarte = null;      
let deuxiemeCarte = null;   
let verrouillage = false;    
let pairesTrouvees = 0;        

// constantes 
const messageElement = document.getElementById('message');
const boutonNouvellePartie = document.getElementById('bouton-nouvelle-partie');
const grilleElement = document.getElementById('grille');

// calcul du total de paires
const totalPaires = symboles.length / 2;

/** mélange le tableau (Fisher–Yates) et renvoie la référence */
function melangerTableau(tableau) {
  for (let i = tableau.length - 1; i > 0; i--) {
    const j = Math.floor(Math.random() * (i + 1));
    [tableau[i], tableau[j]] = [tableau[j], tableau[i]];
  }
  return tableau;
}

/** réinitialise les variables de sélection */
function resetCartes() {
  premiereCarte = null;
  deuxiemeCarte = null;
}

// --- Logique du jeu ---
/** gère le clic sur une carte */
function retournerCarte(carte) {

  // ignore si verrouillé, déjà retournée, ou déjà trouvée
  if (verrouillage || carte.classList.contains('retourne') || carte.classList.contains('paire-trouve')) {
    return;
  }

  // retourne visuellement
  carte.classList.add('retourne');
  carte.textContent = carte.dataset.symbole;

  // sélection 1 puis 2, ensuite on vérifie
  if (!premiereCarte) {
    premiereCarte = carte;
  } else {

    deuxiemeCarte = carte;
    verifierPaire();

  }
}

/** vérifie si les deux cartes sélectionnées forment une paire */
function verifierPaire() {

  // empêche tout autre clic pendant la vérification
  verrouillage = true;

  const symbole1 = premiereCarte.dataset.symbole;
  const symbole2 = deuxiemeCarte.dataset.symbole;

  if (symbole1 === symbole2) {

    // marque comme trouvées
    premiereCarte.classList.add('paire-trouve');
    deuxiemeCarte.classList.add('paire-trouve');

    pairesTrouvees++;

    // victoire
    if (pairesTrouvees === totalPaires) {
      messageElement.textContent = '🎉 YOU ARE THE GOAT 🎉';
    } else {
      messageElement.textContent = ''; // nettoie le message intermédiaire si besoin
    }

    // libère et reset
    resetCartes();
    verrouillage = false;

  } else {

    // laisse voir la paire 1s puis referme
    setTimeout(() => {

      premiereCarte.classList.remove('retourne');
      deuxiemeCarte.classList.remove('retourne');
      premiereCarte.textContent = '';
      deuxiemeCarte.textContent = '';

      resetCartes();
      verrouillage = false;
    }, 1000);

  }

}

/** initialise une partie */

function initialiserJeu() {
  // réinit message/compteur
  messageElement.textContent = '';
  pairesTrouvees = 0;

  // vide la grille
  grilleElement.innerHTML = '';

  // mélange les symboles
  const symbolesAleatoires = melangerTableau([...symboles]);

  // crée les cartes
  symbolesAleatoires.forEach((symbole, idx) => {
    const carte = document.createElement('div');
    carte.className = 'carte';
    carte.dataset.symbole = symbole;
    carte.setAttribute('role', 'gridcell');
    carte.setAttribute('aria-label', `Carte ${idx + 1}`);
    carte.tabIndex = 0; 

    // clic souris
    carte.addEventListener('click', () => retournerCarte(carte));

    // espace/Entrée au clavier
    carte.addEventListener('keydown', (e) => {

      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        retournerCarte(carte);
      }

    });

    grilleElement.appendChild(carte);
  });
}

// ecouteurs
boutonNouvellePartie.addEventListener('click', initialiserJeu);
window.addEventListener('DOMContentLoaded', initialiserJeu);
